# Cacao Predictions Executables

This folder contains executable applications for cacao bean quality prediction.

## Applications

### 1. CacaoPredictionsOO.exe
- Predicts binary classification: OK vs OTHERS
- Uses model pattern: *OO*

### 2. CacaoPredictions_OVS_WMI.exe
- Predicts quality categories: OK/VIOLET/SLATY vs MOULDY/WSPOTS/INSECT
- Uses model pattern: *OVS-MWI*

### 3. CacaoPredictions_O_VSW_MI.exe
- Predicts multiclass classification: INSECT/MOULDY vs OK vs SLATY/VIOLET/WSPOTS
- Uses model pattern: *O-VSW-MI*

### 4. CacaoPredictionsOriginal.exe
- Predicts original 6-class classification: INSECT, MOULDY, OK, SLATY, VIOLET, WSPOTS
- Uses model pattern: *O_AA*

## Setup Instructions

1. **Place your data files:**
   - Copy your CSV data files to the `data/` folder
   - The application will automatically detect and use the first CSV file found

2. **Place your model files:**
   - Copy your trained model files (.keras) to the `models/` folder
   - OO application looks for files containing "OO" in the name
   - OVS-MWI application looks for files containing "OVS-MWI" in the name
   - O-VSW-MI application looks for files containing "O-VSW-MI" in the name
   - Original application looks for files containing "O_AA" in the name

3. **Run the applications:**
   - Double-click on the desired executable
   - The application will automatically process the data and save results to `results/`

## Output

Results are saved in the `results/` folder with timestamped filenames:
- `predictions_OO_YYYYMMDD_HHMMSS.csv`
- `predictions_OVS-MWI_YYYYMMDD_HHMMSS.csv`
- `predictions_O_VSW_MI_YYYYMMDD_HHMMSS.csv`
- `predictions_ORIGINAL_YYYYMMDD_HHMMSS.csv`

## Requirements

- Windows operating system
- No additional software installation required (all dependencies are bundled)

## Troubleshooting

If you encounter any issues:
1. Ensure CSV files are in the `data/` folder
2. Ensure model files are in the `models/` folder
3. Check that model filenames contain the correct patterns (OO, OVS-MWI, O-VSW-MI, or O_AA)
4. Run the executable from Command Prompt to see detailed error messages
